<?php

/* WordPress標準機能 */
function my_setup() {
	add_theme_support( 'post-thumbnails' );			/* アイキャッチ */
	add_theme_support( 'automatic-feed-links' );	/* RSSフィード */
	add_theme_support( 'title-tag' );				/* タイトルタグ自動生成 */
	add_theme_support( 'html5', array(				/* HTML5のタグで出力 */
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption', ) );
}
add_action( 'after_setup_theme', 'my_setup' );

/* メニューの登録 */
function my_menu_init() {
	register_nav_menus( array(
		'global'  => 'グローバルメニュー',
	) );
}
add_action( 'init', 'my_menu_init' );

/* ウィジェットの登録 */
function my_theme_widgets_init() {
	register_sidebar( array(
		'name' => 'Main Sidebar',
		'id' => 'main-sidebar',
	) );
}
add_action( 'widgets_init', 'my_theme_widgets_init' );
